	function N = BW_ORDER_HB_Z(wsT, Amin)
	
	% 	Computes the required order for a digital lowpass 
	%	half-band Butterworth filter of odd order.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 2010-11-09
	% 	Modified by: 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1 
	% 	Known bugs:			 
	% 	Report bugs to:	Wanhammar@gmail.com
	%
	
	if  (wsT <= pi/2)
		error('Not a half-band lowpass filter. Must have wsT > /2')  
	elseif ( Amin <= 0)
		error('The stopband attenuation Amin must be > 0')
	elseif ( Amin > 200)
		error('The stopband attenuation is too large')
	end 
	% N must be an integer
	if ~(abs(N-round(N)) < eps)
		error('N must be an integeer')  
		return
	end
	if mod(N, 2) == 0 | N < 3
		% disp([' Error  The filer order must be odd'])
		return
	end	
	ws = tan(wsT/2);		% Symmetry requirement
	wc = tan((pi-wsT)/2);	
	es = 10^(Amin/10) -1;
	ep = 1/es;				% Symmetry requirement
	N = log10(es^2)/(2*log10(ws/wc));
	
	
